<?php
defined('PF_VERSION') OR exit('Access denied');
$mail = new Pf_Mail();
$form_displayname = array('name' => 'displayname', 'placeholder' => __('Display Name', 'user'));
$form_username = array('name' => 'username', 'placeholder' => __('Username', 'user'));
$form_email = array('name' => 'email', 'placeholder' => __('Email', 'user'));
$settings = Pf::setting();
$user_page = public_url('user',false);
$auth = new Auth();
$captcha    = get_captcha();
$error = array();
if ($captcha!=FALSE) 
    require_once ABSPATH . '/includes/recaptchalib.php';
if (!$auth->is_logged_in()) {
    if (!empty($_POST)) {
        if ($_POST['type'] == 'forgot') {
            if ($captcha != FALSE) {
                $resp = recaptcha_check_answer($captcha['privatekey'], $_SERVER["REMOTE_ADDR"], $_POST["recaptcha_challenge_field"], $_POST["recaptcha_response_field"]);
                if (!$resp->is_valid) {
                    $error['forgotmail'][0] = __("Wrong Captcha Code", 'user')."<br>";
                }
            }
            if(!isset($error['forgotmail'])){
                $email = $_POST['forgot-email'];
                $key = $auth->forgot_password($email);
                if($key!=false){
                    $mail->mail_forgot($email,$key);
                    $success_forgot =   1;
                    $error['success'][0] = __('An email to reset your password has been sent', 'user');
                }else{
                    $error['forgotmail'][0] = __('Your email does not exist', 'user');
                }
            }
        }
    }
    require_once 'views/views-forgot.php';
} else
    header('location: ' . public_url(get_configuration('default_page'),false));